//Dustin Soodak
#include "RingoI2C.h"

#include <MoodyWire.h> 
//put "MoodyWireLibrary\MoodyWire" into "C:\Program Files\Arduino\libraries"


//Note: "using Print::write;"



//Accelerometer:
//http://cache.freescale.com/files/sensors/doc/data_sheet/MMA8451Q.pdf
//p.18
//
//Gyroscope:
//http://www.st.com/web/en/resource/technical/document/datasheet/DM00036465.pdf
//p.23-24
//
//Gyro: "Use same format for read/write single/multiple bytes"
//Accel: "The MMA8451Q automatically increments the received register address commands after a write command is received"









void I2CBegin(void){
  Wire.begin();
}


//#include "twi.h"//C:\Program Files\Arduino\libraries\Wire\utility
//read = twi_readFrom(address, rxBuffer, quantity, sendStop);
//twi_writeTo(txAddress, txBuffer, txBufferLength, 1, sendStop);
//uint8_t twi_writeTo(uint8_t address, uint8_t* data, uint8_t length, uint8_t wait, uint8_t sendStop)

uint8_t I2CReadRegs(uint8_t Device, uint8_t Reg, uint8_t *RxBuffer, uint8_t Length){  
  /*uint8_t res;
  twi_writeTo(Device, &Reg, 1, 1, false);
  res = twi_readFrom(Device, RxBuffer, Length, true);
  return res;*/
  uint8_t i;
  Wire.beginTransmission(Device); // transmit to device (note: actually just starts filling of buffer)
  Wire.write(Reg);
  Wire.endTransmission(0);//send data without stop at end
  Wire.requestFrom(Device, Length);
  i=0;
  while(Wire.available()){
    RxBuffer[i]=Wire.read(); 
    i++;
  }
  return i;  
}
uint8_t I2CReadReg(uint8_t Device, uint8_t Reg){  
  /*uint8_t res=0;
  twi_writeTo(Device, &Reg, 1, 1, false);
  twi_readFrom(Device, &res, 1, true);
  return res;*/
  uint8_t dat=0;
  I2CReadRegs(Device, Reg, &dat, 1);
  return dat;
}
void I2CWriteRegs(uint8_t Device, uint8_t Reg, uint8_t *TxBuffer, uint8_t Length){
  char i;
  Wire.beginTransmission(Device); // transmit to device (note: actually just starts filling of buffer)
  Wire.write(Reg);              // sends one byte 
  for(i=0;i<Length;i++){
    Wire.write(TxBuffer[i]); 
  }
  Wire.endTransmission();    //send data with stop at end 
  
  //twi_writeTo(Device, TxBuffer, Length, 1, true);//make modified version with "Reg" field.
}
void I2CWriteReg(uint8_t Device, uint8_t Reg, uint8_t TxData){
  I2CWriteRegs( Device, Reg, &TxData, 1);
  /*Wire.beginTransmission(Device); 
  Wire.write(Reg); 
  Wire.writeTxData; 
  Wire.endTransmission();*/
  //twi_writeTo(Device, &TxData, 1, 1, true);
}
